---
generated_at: 2026-02-03 10:30:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：7-Segments Report

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - 全項目に根拠あり。重点レビュー項目なし。

## 2) 参照した情報（Evidence一覧）

- E-01: `server/src/main/java/org/opensearch/rest/action/cat/RestSegmentsAction.java` 行69-210
- E-02: `docs/code-to-docs/帳票一覧/帳票一覧.csv` 行8

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | エンドポイントは GET /_cat/segments と GET /_cat/segments/{index} | E-01 行81 | ○ |
| C-02 | allowSystemIndexAccessByDefault が true | E-01 行90-92 | ○ |
| C-03 | isRequestLimitCheckSupported が true | E-01 行95-97 | ○ |
| C-04 | ResponseLimitBreachedException のメッセージ | E-01 行133 | ○ |
| C-05 | ClusterStateRequest で nodes=true, routingTable=true | E-01 行109 | ○ |
| C-06 | 15カラムの定義 | E-01 行148-163 | ○ |
| C-07 | size.memory は固定値 0L | E-01 行194 | ○ |
| C-08 | prirep は p/r の2値 | E-01 行186 | ○ |
| C-09 | 4重ネストのループ構造 | E-01 行172-201 | ○ |
| C-10 | 2段階のAPI呼び出し（State → Segments） | E-01 行111,117 | ○ |
| C-11 | RoutingTable ベースのレスポンス制限チェック | E-01 行132 | ○ |
| C-12 | Segment.isCommitted/isSearch/isCompound | E-01 行195-198 | ○ |
| C-13 | id カラムは default:false | E-01 行152 | ○ |
| C-14 | 帳票一覧での定義内容 | E-02 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コンパクトなクラスで全処理が明確

## 6) レビュアーチェックリスト（最小）
- [ ] 15カラムの定義がソースコードと一致しているか
- [ ] size.memory が本当に固定値0Lであるか確認
- [ ] ResponseLimit のチェック対象（RoutingTable ベース）が正確か
